def max_power(n, p):
    # Префіксні суми для масиву p
    prefix_sum = [0] * (n + 1)
    
    for i in range(1, n + 1):
        prefix_sum[i] = prefix_sum[i - 1] + p[i - 1]
    
    # Загальна потужність (сума всіх елементів)
    total_power = prefix_sum[n]
    
    # Змінна для збереження максимального значення потужності
    max_power = total_power
    
    # Перебір усіх пар (l, r)
    for l in range(n):
        for r in range(l + 1, n):
            # Для кожної пари (l, r) перевіряємо можливі варіанти x
            max_x = (r - l) // 2  # максимальний x
            for x in range(1, max_x + 1):
                # Потужність прихованих дронів за допомогою префіксних сум
                hidden_left = prefix_sum[l + x] - prefix_sum[l]  # Ліва частина
                hidden_right = prefix_sum[r + 1] - prefix_sum[r - x + 1]  # Права частина
                
                # Потужність виставки без прихованих дронів
                current_power = total_power - hidden_left - hidden_right
                
                # Оновлюємо максимальну потужність
                max_power = max(max_power, current_power)
    
    return max_power

# Вхідні дані
n = int(input())  # довжина масиву
p = list(map(int, input().split()))  # масив потужностей дронів

# Виведення результату
print(max_power(n, p))